<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Call;
use Bixo\Database\Notifications\CallWorkflow as CallNotifyer;
use Notification;

class CallNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Call $call
     *
     * @return void
     */
    public function complete(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Call $call
     *
     * @return void
     */
    public function verify(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Call $call
     *
     * @return void
     */
    public function approve(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Call $call
     *
     * @return void
     */
    public function publish(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Call $call
     *
     * @return void
     */
    public function archive(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Call $call
     *
     * @return void
     */
    public function unpublish(Call $call)
    {
        return Notification::send($call->user, new CallNotifyer($call, 'unpublish'));;

    }
}
