<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Call;
use Validator;

class CallValidator
{

    /**
     * Determine if the given call is valid for complete status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function complete(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given call is valid for verify status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function verify(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given call is valid for approve status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function approve(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given call is valid for publish status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function publish(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given call is valid for archive status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function archive(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given call is valid for unpublish status.
     *
     * @param Call $call
     *
     * @return bool / Validator
     */
    public function unpublish(Call $call)
    {
        return Validator::make($call->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
