<?php

namespace Bixo\Database\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Bixo\Database\Models\Database;

class DatabaseAction
{
    /**
     * Perform the complete action.
     *
     * @param Database $database
     *
     * @return Database
     */
    public function complete(Database $database)
    {
        try {
            $database->status = 'complete';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Database $database
     *
     * @return Database
     */public function verify(Database $database)
    {
        try {
            $database->status = 'verify';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Database $database
     *
     * @return Database
     */public function approve(Database $database)
    {
        try {
            $database->status = 'approve';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Database $database
     *
     * @return Database
     */public function publish(Database $database)
    {
        try {
            $database->status = 'publish';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Database $database
     *
     * @return Database
     */
    public function archive(Database $database)
    {
        try {
            $database->status = 'archive';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Database $database
     *
     * @return Database
     */
    public function unpublish(Database $database)
    {
        try {
            $database->status = 'unpublish';
            return $database->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
