<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Database;
use Bixo\Database\Notifications\DatabaseWorkflow as DatabaseNotifyer;
use Notification;

class DatabaseNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Database $database
     *
     * @return void
     */
    public function complete(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Database $database
     *
     * @return void
     */
    public function verify(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Database $database
     *
     * @return void
     */
    public function approve(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Database $database
     *
     * @return void
     */
    public function publish(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Database $database
     *
     * @return void
     */
    public function archive(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Database $database
     *
     * @return void
     */
    public function unpublish(Database $database)
    {
        return Notification::send($database->user, new DatabaseNotifyer($database, 'unpublish'));;

    }
}
