<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Database;
use Validator;

class DatabaseValidator
{

    /**
     * Determine if the given database is valid for complete status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function complete(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given database is valid for verify status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function verify(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given database is valid for approve status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function approve(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given database is valid for publish status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function publish(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given database is valid for archive status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function archive(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given database is valid for unpublish status.
     *
     * @param Database $database
     *
     * @return bool / Validator
     */
    public function unpublish(Database $database)
    {
        return Validator::make($database->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
