<?php

namespace Bixo\Database\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use Bixo\Database\Models\Upload;

class UploadAction
{
    /**
     * Perform the complete action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */
    public function complete(Upload $upload)
    {
        try {
            $upload->status = 'complete';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */public function verify(Upload $upload)
    {
        try {
            $upload->status = 'verify';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */public function approve(Upload $upload)
    {
        try {
            $upload->status = 'approve';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */public function publish(Upload $upload)
    {
        try {
            $upload->status = 'publish';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */
    public function archive(Upload $upload)
    {
        try {
            $upload->status = 'archive';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Upload $upload
     *
     * @return Upload
     */
    public function unpublish(Upload $upload)
    {
        try {
            $upload->status = 'unpublish';
            return $upload->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
