<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Upload;
use Bixo\Database\Notifications\UploadWorkflow as UploadNotifyer;
use Notification;

class UploadNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function complete(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function verify(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function approve(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function publish(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function archive(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Upload $upload
     *
     * @return void
     */
    public function unpublish(Upload $upload)
    {
        return Notification::send($upload->user, new UploadNotifyer($upload, 'unpublish'));;

    }
}
