<?php

namespace Bixo\Database\Workflow;

use Bixo\Database\Models\Upload;
use Validator;

class UploadValidator
{

    /**
     * Determine if the given upload is valid for complete status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function complete(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given upload is valid for verify status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function verify(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given upload is valid for approve status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function approve(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given upload is valid for publish status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function publish(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given upload is valid for archive status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function archive(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given upload is valid for unpublish status.
     *
     * @param Upload $upload
     *
     * @return bool / Validator
     */
    public function unpublish(Upload $upload)
    {
        return Validator::make($upload->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
