<?php


return  
    [
        'model' => [
            'model' => \Bixo\Developer\Models\Developer::class,
            'table' => 'bixo_developer_developers',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['name',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'developer/developer',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
             
                'marking'    => 'array',
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "name", 
                "type" => "text", 
                "label" => 'developer::developer.label.name', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'name',
                "element" => 'text',
                "type" => 'text',
                "label" => 'developer::developer.label.name',
                "placeholder" => 'developer::developer.placeholder.name',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'developer/developer/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'developer/developer/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'developer/developer',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'developer/developer',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'developer/developer',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'developer/developer',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'developer::developer.label.created_at',
            'name' => 'developer::developer.label.name',
            'status' => 'developer::developer.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "developer::developer.groups.main",
                'group' => "main.main",
                'title' => "developer::developer.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "developer::developer.groups.details",
                'group' => "main.details",
                'title' => "developer::developer.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "developer::developer.groups.images",
                'group' => "main.images",
                'title' => "developer::developer.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "developer::developer.groups.settings",
                'group' => "main.settings",
                'title' => "developer::developer.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Developer',
            'module' => 'Developer',
        ],

         
        'workflow' => [
            'type' => 'workflow',
            'marking_store' => [
                'type' => 'multiple_state',
                'arguments' => ['status'],
                // 'property' => 'status'
            ],
            'supports' => [
                \Bixo\Developer\Models\Developer::class,
            ],
            'places' => [
                'Draft',
                'Pending',
                'Approved',
                'Closed',
                'Published',
                'Archived',
                'Unpublished',
            ],
            'initial_places' => ['Draft'],
            'transitions' => [
                'submit' => [
                    'from' => 'Draft',
                    'to' => 'Pending',
                    'metadata' => [
                        'roles' => [
                            'user' => ['*'],
                        ],
                        'rules' => [
                            'name' => 'required',
                        ]
                    ],
                ],
                'reject' => [
                    'from' => 'Pending',
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ],
                        'form' => [
                            'title' => 'Reject',
                            'button' => [
                                'cancel' > [
                                    'icon' > '',
                                    'varient' > '',
                                    'label' > 'Cancel'
                                ],
                                'submit' > [
                                    'icon' > '',
                                    'varient' > 'primary',
                                    'label' > 'Reject'
                                ]
                            ],
                            'fields' => [
                                'count' => [
                                    "element" => 'select',
                                    "type" => 'select',
                                    "label" => 'advert::advert.label.count',
                                    "placeholder" => 'advert::advert.placeholder.count',
                                    "options" => call_user_func(function () {
                                        return [
                                            1 => ['value' => 1, 'text' => 1],
                                            2 => ['value' => 2, 'text' => 2],
                                            3 => ['value' => 3, 'text' => 3],
                                            4 => ['value' => 4, 'text' => 4],
                                        ];
                                    }),
                                    "col" => "12",
                                ],
                                'comment' => [
                                    "element" => 'textarea',
                                    "type" => 'text',
                                    "required" => 'required',
                                    "label" => 'advert::advert.label.comment',
                                    "placeholder" => 'advert::advert.placeholder.comment',
                                    "col" => "12",
                                ],
                            ],
                        ],
                    ],
                ],
                'approve' => [
                    'from' => 'Pending',
                    'to' => 'Approved',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin', 'manager'],
                        ]
                    ],
                ],
                'publish' => [
                    'from' => ['Approved', 'Unpublished'],
                    'to' => 'Published',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unpublish' => [
                    'from' => ['Published'],
                    'to' => 'Unpublished',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'archive' => [
                    'from' => ['Published', 'Unpublished'],
                    'to' => 'Archived',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
                'unarchive' => [
                    'from' => ['Archived'],
                    'to' => 'Draft',
                    'metadata' => [
                        'roles' => [
                            'user' => ['superuser', 'admin'],
                            'team' => ['admin'],
                        ]
                    ],
                ],
            ],
        ],
        
         
        'actions' => [
            'copy' => [
                'type' => ['Details', 'List'],
                'label' => 'developer::developer.action.copy',
                'roles' => [
                    'user' => ['superuser', 'admin'],
                    'team' => ['admin'],
                    'permission' => ['developer.developer.copy', 'developer.developer.duplicate'],
                ],
                'form' => [
                    'count' => [
                        "element" => 'select',
                        "type" => 'select',
                        "label" => 'developer::developer.label.count',
                        "placeholder" => 'developer::developer.placeholder.count',
                        "options" => call_user_func(function () {
                            return [
                                1 => ['value' => 1, 'text' => 1],
                                2 => ['value' => 2, 'text' => 2],
                                3 => ['value' => 3, 'text' => 3],
                                4 => ['value' => 4, 'text' => 4],
                            ];
                        }),
                        "col" => "12",
                    ],
                    'comment' => [
                        "element" => 'textarea',
                        "type" => 'text',
                        "required" => 'required',
                        "label" => 'developer::developer.label.comment',
                        "placeholder" => 'developer::developer.placeholder.comment',
                        "col" => "12",
                    ],
                ],
            ],
            'empty' => [
                'type' => ['List', 'Details'],
                'label' => 'developer::developer.action.empty',
                'roles' => [
                    'user' => ['superuser'],
                ],
            ],
            
            'section' => [
                'type' => ['Group'],
                'api_url' => '',
                'action' => 'list',
                'label' => 'developer::developer.action.section',
                'store' => 'main.units',
                'group' => 'main.units'
            ],

        ]
        
    ];
