<?php

namespace Bixo\Developer\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class DeveloperTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_developer_developers')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.developer.developer.view',
                'name'      => 'View Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.create',
                'name'      => 'Create Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.edit',
                'name'      => 'Update Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.delete',
                'name'      => 'Delete Developer',
            ],
            
                        [
                'slug'      => 'bixo.developer.developer.verify',
                'name'      => 'Verify Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.approve',
                'name'      => 'Approve Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.publish',
                'name'      => 'Publish Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.unpublish',
                'name'      => 'Unpublish Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.cancel',
                'name'      => 'Cancel Developer',
            ],
            [
                'slug'      => 'bixo.developer.developer.archive',
                'name'      => 'Archive Developer',
            ],
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/developer/developer',
                'name'        => 'Developer',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/developer/developer',
                'name'        => 'Developer',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'developer',
                'name'        => 'Developer',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Developer',
                'module'    => 'Developer',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.developer.developer.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
