# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/developer/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/bixo/developer"
        }

        ...
    },
...

```
Then run `composer require bixo/developer`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Bixo\\Developer\\Seeders\\DeveloperTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Bixo\Developer\Providers\DeveloperServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Bixo\Developer\Providers\DeveloperServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Bixo\Developer\Providers\DeveloperServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/developer/{modulename}
```

* User
```
    http://path-to-route-folder/user/developer/{modulename}
```

* Public
```
    http://path-to-route-folder/developers
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/developer/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/developer/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/developer/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/developer/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/developer/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/developer/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/developer/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/developer/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/developer/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/developer/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/developer/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
