@include('developer::public.developer.partial.header')
<section class="listing-page-wrap">
    <div class="container">
        <div class="row">
            @include('developer::public.developer.partial.aside')

            <div class="col-12 col-lg-9 left-sidebar" id="listing_data">
                @forelse($developers as $developer)
                @php 
                $developer = $developer->toArray([]);
                @endphp
                <div class="listing-single-item d-flex align-items-center flex-wrap">
                    <div class="col-12 col-lg-5 p-0 listing-image">
                        <a href="{{trans_url('developer')}}/{{$developer['slug']}}">
                        <img src="{{url($developer['image']['main'])}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col-12 col-lg-6 p-0 listing-text">
                        <div class="listing-content">
                            <h3><a href="{{trans_url('developer')}}/{{$developer['slug']}}">{{$developer['title']}}</a></h3>
                            <div class="listing-metas">
                                <span>By <a
                                        href="{{trans_url('developer')}}/{{$developer['slug']}}">User</a></span>
                                <span><a
                                        href="{{trans_url('developer')}}/{{$developer['slug']}}">Category</a></span>
                            </div>
                            <p>{{ Str::limit($developer['description'], 300 )}}</p>
                        </div>
                        <a href="{{trans_url('developer')}}/{{$developer['slug']}}" class="btn btn-theme">Continue Reading</a>
                    </div>
                </div>
                <nav class="pagination-wrap mb-50" aria-label="Page navigation example">
                    <ul class="pagination">
                        @php 
                        $meta = $developer['meta'];
                        @endphp
                        {!!view('paginator', compact('meta'))!!}
                    </ul>
                </nav>
                @empty
                @endif
            </div>
        </div>
    </div>
</section>
