<?php

// Web routes  for developer.

include('routes.php');


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            include('routes.php');

        }
    );
}

// Workflow routes for developer

Route::prefix('{guard}/developer')->group(function () {

    Route::get('/workflow/{developer}/{user}', 'DeveloperWorkflowController@get')
        ->name('bixo.developer.workflow');
    Route::post('/workflow/{developer}/{user}', 'DeveloperWorkflowController@post');

    Route::get('/action/{developer}/{user}', 'DeveloperActionController@get')
        ->name('bixo.developer.action');
    Route::post('/action/{developer}/{user}', 'DeveloperActionController@post');

});

