<?php

namespace Bixo\Developer\Actions;

use Illuminate\Http\Request;
use Bixo\Developer\Models\Developer;
use Litepie\Actions\Concerns\AsAction;
use Illuminate\Support\Str;

class DeveloperWorkflow
{
    use AsAction;
    
    private $model;
    private $namespace = 'bixo.developer.$developer';
    private $transition;
    protected $eventClass = \Bixo\Developer\Events\DeveloperWorkflow::class;
    private $function;
    private $request;

    public function handle(string $transition, Developer $developer, array $request = [])
    {
        $this->model = $developer;
        $this->request = $request;
        $this->transition = $transition;
        $this->function = Str::camel($transition);
        $this->executeWorkflow();
        return $this->model;
    }

    public function submit()
    {
        $this->model->status = 'Pending';
        $this->model->save();
        return $this->model;
    }

    public function approve()
    {
        $this->model->status = 'Approved';
        $this->model->save();
        return $this->model;
    }

    public function reject()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }

    public function publish()
    {
        $this->model->status = 'Published';
        $this->model->save();
        return $this->model;
    }

    public function unpublish()
    {
        $this->model->status = 'Unpublished';
        $this->model->save();
        return $this->model;
    }

    public function archive()
    {
        $this->model->status = 'Archived';
        $this->model->save();
        return $this->model;
    }

    public function unarchive()
    {
        $this->model->status = 'Draft';
        $this->model->save();
        return $this->model;
    }
}
