<?php

namespace Bixo\Developer\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Bixo\Developer\Models\Developer;

class DeveloperAction
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(
        public string $action,
        public Developer $developer,
        public array $request = [],
        public string $when = 'after'
    ) {}
}
