<?php

namespace Bixo\Developer\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Bixo\Developer\Actions\DeveloperAction;
use Bixo\Developer\Http\Requests\DeveloperActionRequest;
use Bixo\Developer\Http\Resources\DeveloperResource;
use Bixo\Developer\Models\Developer;

/**
 * Admin web controller class.
 */
class DeveloperActionController extends BaseController
{

    /**
     * Action controller function for developer.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(DeveloperActionRequest $request, Developer $developer, $action)
    {
        try {
            $request = $request->all();
            $developer = DeveloperAction::run($action, $developer, $request);

            $data = new DeveloperResource($developer);
            return $this->response->message(trans("messages.success.{$action}", ['Module' => trans('developer::developer.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('developer/developer/' . $developer->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('developer/developer/' . $developer->getRouteKey()))
                ->redirect();
        }
    }

    public function notify(){
        
    }
}
