<?php

namespace Bixo\Developer\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Exception;
use Bixo\Developer\Http\Requests\DeveloperActionsRequest;
use Bixo\Developer\Actions\DeveloperActions;

/**
 * Admin web controller class.
 */
class DeveloperActionsController extends BaseController
{

    /**
     * Action controller function for developer.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(DeveloperActionsRequest $request, $action)
    {
        try {
            $developer = DeveloperActions::run($request, $action);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('developer::developer.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('developer/developer/' . $action))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('developer/developer/' . $action))
                ->redirect();
        }
    }
}
