<?php

namespace Bixo\Developer\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Bixo\Developer\Http\Resources\DeveloperResource;
use Bixo\Developer\Http\Resources\DevelopersCollection;
use Bixo\Developer\Scopes\DeveloperPublicScope;
use Bixo\Developer\Models\Developer;

class DeveloperPublicController extends BaseController
{

    /**
     * Show developer's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = Developer::pushScope(new RequestScope())
            ->pushScope(new DeveloperPublicScope())
            ->paginate($pageLimit)
            ->withQueryString();

        $developers = new DevelopersCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('developer::developer.names'))
            ->view('developer::public.developer.index')
            ->data(compact('developers', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show developer.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = Developer::findBySlug($slug);
        $data = new DeveloperResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('developer::developer.name'))
            ->view('developer::public.developer.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
