<?php

namespace Bixo\Developer\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Bixo\Developer\Actions\DeveloperReport;
use Bixo\Developer\Http\Requests\DeveloperReportRequest;

/**
 * Admin web controller class.
 */
class DeveloperReportController extends BaseController
{
    /**
     * Action controller function for developer.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(DeveloperReportRequest $request, $report)
    {
        try {
        
            $this->model = app(Developer::class);
            $data = DeveloperReport::run($request, $report);

            return $this->response->message(trans('messages.success.updated', ['Module' => trans('developer::developer.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('developer/developer/' . $report))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('developer/developer/' . $report))
                ->redirect();
        }
    }
}
