<?php

namespace Bixo\Developer\Http\Requests;

use Litepie\Http\Request\AbstractRequest;

class DeveloperActionRequest extends AbstractRequest
{

    /* Model for the current request.
     *
     * @var array
     */
    protected $action;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $this->model = $this->route('developer');
        $this->action = $this->getAction();
        // Determine if the user is authorized to perform the action.
        return $this->can($this->action);

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return config('litecms.developer.developer.action.role', []);
    }

}
