<?php
namespace Bixo\Developer\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Bixo\Developer\Events\DeveloperAction as DeveloperActionEvent;
use Bixo\Developer\Models\Developer;

class DeveloperAction extends Notification implements ShouldQueue
{
    use Queueable;

    protected $event;
    protected $developer;
    protected $action;
    protected $request;

    /**
     * Create a new notification instance.
     *
     * @param DeveloperActionEvent $developer
     */
    public function __construct(DeveloperActionEvent $developer)
    {
        $this->action = $event->action;
        $this->developer = $developer;
        $this->request = $event->request;
        $this->event = $event;

    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Developer Approved - ' . config('app.name'))
            ->view('developer::developer.email.action', ['data' => $this->developer]);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param object $notifiable
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }
}
