<?php

namespace Bixo\Developer\Policies;

use Bixo\Developer\Models\Developer;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait DeveloperAction
{

    /**
     * Determine if the given user can copy the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function copy(Authenticatable $user, Developer $developer)
    {

        if ($authUser->canDo('developer.developer.action.copy')) {
            return true;
        }

        $this->model->is_owner;
    }

    /**
     * Determine if the given user can empty the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    function empty(Authenticatable $user, Developer $developer) {

        if ($authUser->canDo('developer.developer.action.empty')) {
            return true;
        }

        $this->model->is_owner;
    }

    /**
     * Determine if the given user can transfer the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function transfer(Authenticatable $user, Developer $developer)
    {

        if ($authUser->canDo('developer.developer.action.transfer')) {
            return true;
        }

        $this->model->is_owner;
    }

}
