<?php


namespace Bixo\Developer\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;

trait DeveloperReport
{

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function povote(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('developer.developer.report.povote')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function report(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('developer.developer.report')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function download(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('developer.developer.report.download')) {
            return true;
        }

        return false;
    }
}
