<?php

namespace Bixo\Developer\Policies;

use Bixo\Developer\Models\Developer;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait DeveloperWorkflow
{

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function approve(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function submit(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.submit')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function publish(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.publish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unpublish(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.unpublish')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function archive(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.archive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function unarchive(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.unarchive')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function reject(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.reject')) {
            return true;
        }

        return false;
    }

}
