<?php

namespace Bixo\Developer\Providers;

use Illuminate\Support\ServiceProvider;
use Bixo\Developer\Developers;

class DeveloperServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'developer');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'developer');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        $this->registerCommands();

        $this->app->register(\Bixo\Developer\Providers\AuthServiceProvider::class);
        $this->app->register(\Bixo\Developer\Providers\RouteServiceProvider::class);
        $this->app->register(\Bixo\Developer\Providers\ActionServiceProvider::class);
        $this->app->register(\Bixo\Developer\Providers\EventServiceProvider::class);
        $this->app->register(\Bixo\Developer\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('bixo.developer', function($app)
        {
            return $this->app->make(Developer::class);
        });
    }

    /**
     * Merges user's and developer's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.developer'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/developer.php', 'bixo.developer.developer'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Bixo\Developer\Commands\Developer::class,
            ]);
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.developer'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('bixo/developer')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/developer')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/developer')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
