<?php

namespace Bixo\Developer\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Bixo\Developer\Events\DeveloperAction;
use Bixo\Developer\Events\DeveloperWorkflow;
use Bixo\Developer\Listeners\DeveloperAction as DeveloperActionListener;
use Bixo\Developer\Listeners\DeveloperWorkflow as DeveloperWorkflowListener;


class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
    
        DeveloperAction::class => [
            DeveloperActionListener::class,
        ],
        DeveloperWorkflow::class => [
            DeveloperWorkflowListener::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param \Illuminate\Contracts\Events\Dispatcher $events
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
