<?php

namespace Bixo\Developer\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Developer\Models\Developer;


class DeveloperAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.developer.developer';
    protected $eventClass = \Bixo\Developer\Events\DeveloperAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Developer $developer, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $developer;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Developer $developer, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $developer = $developer->create($attributes);
        return $developer;
    }

    public function update(Developer $developer, array $request)
    {
        $attributes = $request;
        $developer->update($attributes);
        return $developer;
    }

    public function destroy(Developer $developer, array $request)
    {
        $developer->delete();
        return $developer;
    }

    public function copy(Developer $developer, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $developer = $developer->replicate();
            $developer->created_at = Carbon::now();
            $developer->save();
            return $developer;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $developer->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $developer;
    }


}
