<?php

namespace Bixo\Developer\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Developer\Events\DeveloperAction as DeveloperActionEvent;
use Bixo\Developer\Notifications\DeveloperAction as DeveloperActionNotification;
use Litepie\Actions\Concerns\AsAction;

class DeveloperAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the DeveloperActionEvent.
     *
     * @param   DeveloperActionEvent  $event
     * @return mixed
     */
    public function handle(DeveloperActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $developer.
     *
     * @param   DeveloperActionEvent  $event
     * @return void
     */
    public function create(DeveloperActionEvent $event)
    {
        $client = $event->developer->client;
        Notification::send($client, new DeveloperActionNotification($event));
    }

    /**
     * Handle the DeveloperActionEvent as a listener.
     *
     * @param   DeveloperActionEvent  $event
     * @return mixed
     */
    public function asListener(DeveloperActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   DeveloperActionEvent  $event
     * @return bool
     */
    private function isAllowed(DeveloperActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
