<?php

namespace Bixo\Developer\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Developer\Models\Developer;

class DeveloperPolicy
{


    /**
     * Determine if the given user can view the developer.
     *
     * @param Authenticatable $user
     * @param Developer $developer
     *
     * @return bool
     */
    public function view(Authenticatable $user, Developer $developer)
    {
        if ($authUser->canDo('developer.developer.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $developer->is_owner;
    }

    /**
     * Determine if the given user can create a developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('developer.developer.create');
    }

    /**
     * Determine if the given user can update the given developer.
     *
     * @param Authenticatable $user
     * @param Developer $developer
     *
     * @return bool
     */
    public function update(Authenticatable $user, Developer $developer)
    {
        if ($user->canDo('developer.developer.edit') && $user->isAdmin()) {
            return true;
        }

        return $developer->is_owner;
    }

    /**
     * Determine if the given user can delete the given developer.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Developer $developer)
    {
        return $developer->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
