# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/67ilt/lkjhrew/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/67ilt/lkjhrew/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "67ilt\\Lkjhrew\\": "packages/67ilt/lkjhrew/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        67ilt\Lkjhrew\Providers\LkjhrewServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Lkjhrew'  => 67ilt\Lkjhrew\Facades\Lkjhrew::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=67ilt\\LkjhrewTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="67ilt\Lkjhrew\Providers\LkjhrewServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="67ilt\Lkjhrew\Providers\LkjhrewServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="67ilt\Lkjhrew\Providers\LkjhrewServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/lkjhrew/{modulename}

**User**

    http://path-to-route-folder/user/lkjhrew/{modulename}

**Public**

    http://path-to-route-folder/lkjhrews


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/lkjhrew/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/lkjhrew/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/lkjhrew/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/lkjhrew/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/lkjhrew/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/lkjhrew/{modulename}/{slug}
    METHOD: GET