<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'litecms',

    /*
     * Package.
     */
    'package'   => 'document',

    /*
     * Modules.
     */
    'modules'   => ['document'],

    
    'document'       => [
        'model' => [
            'model'                 => \Litecms\Document\Models\Document::class,
            'table'                 => 'documents',
            'presenter'             => \Litecms\Document\Repositories\Presenter\DocumentPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['title',  'path',  'description',  'type'],
            'translatables'         => [],
            'upload_folder'         => 'document/document',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Litecms',
            'package'   => 'Document',
            'module'    => 'Document',
        ],

    ],
];
