<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: documents
         */
        Schema::create('documents', function ($table) {
            $table->increments('id');
            $table->string('title', 255)->nullable();
            $table->string('path', 255)->nullable();
            $table->text('description')->nullable();
            $table->string('type', 255)->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('documents');
    }
}
