<?php

namespace Litecms\Document\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class DocumentTransformer extends TransformerAbstract
{
    public function transform(\Litecms\Document\Models\Document $document)
    {
        return [
            'id'                => $document->getRouteKey(),
            'key'               => [
                'public'    => $document->getPublicKey(),
                'route'     => $document->getRouteKey(),
            ], 
            'title'             => $document->title,
            'path'              => $document->path,
            'description'       => $document->description,
            'type'              => $document->type,
            'url'               => [
                'public'    => trans_url('document/'.$document->getPublicKey()),
                'user'      => guard_url('document/document/'.$document->getRouteKey()),
            ], 
            'status'            => trans('app.'.$document->status),
            'created_at'        => format_date($document->created_at),
            'updated_at'        => format_date($document->updated_at),
        ];
    }
}