<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'superrobota',

    /*
     * Package.
     */
    'package'   => 'document',

    /*
     * Modules.
     */
    'modules'   => ['documents'],

    
    'documents'       => [
        'model' => [
            'model'                 => \Superrobota\Document\Models\Documents::class,
            'table'                 => 'documents',
            'presenter'             => \Superrobota\Document\Repositories\Presenter\DocumentsPresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['name'],
            'translatables'         => [],
            'upload_folder'         => 'document/documents',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Superrobota',
            'package'   => 'Document',
            'module'    => 'Documents',
        ],

    ],
];
