<?php

namespace Superrobota\Document;

use User;

class Document
{
    /**
     * $documents object.
     */
    protected $documents;

    /**
     * Constructor.
     */
    public function __construct(\Superrobota\Document\Interfaces\DocumentsRepositoryInterface $documents)
    {
        $this->documents = $documents;
    }

    /**
     * Returns count of document.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.documents.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->documents->pushCriteria(new \Litepie\Superrobota\Repositories\Criteria\DocumentsUserCriteria());
        }

        $documents = $this->documents->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('document::' . $view, compact('documents'))->render();
    }
}
