<?php

namespace Superrobota\Document\Policies;

use Litepie\User\Contracts\UserPolicy;
use Superrobota\Document\Models\Documents;

class DocumentsPolicy
{

    /**
     * Determine if the given user can view the documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function view(UserPolicy $user, Documents $documents)
    {
        if ($user->canDo('document.documents.view') && $user->isAdmin()) {
            return true;
        }

        return $documents->user_id == user_id() && $documents->user_type == user_type();
    }

    /**
     * Determine if the given user can create a documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('document.documents.create');
    }

    /**
     * Determine if the given user can update the given documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function update(UserPolicy $user, Documents $documents)
    {
        if ($user->canDo('document.documents.edit') && $user->isAdmin()) {
            return true;
        }

        return $documents->user_id == user_id() && $documents->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Documents $documents)
    {
        return $documents->user_id == user_id() && $documents->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Documents $documents)
    {
        if ($user->canDo('document.documents.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given documents.
     *
     * @param UserPolicy $user
     * @param Documents $documents
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Documents $documents)
    {
        if ($user->canDo('document.documents.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
