<?php

namespace Superrobota\Document\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class DocumentsTransformer extends TransformerAbstract
{
    public function transform(\Superrobota\Document\Models\Documents $documents)
    {
        return [
            'id'                => $documents->getRouteKey(),
            'key'               => [
                'public'    => $documents->getPublicKey(),
                'route'     => $documents->getRouteKey(),
            ], 
            'name'              => $documents->name,
            'url'               => [
                'public'    => trans_url('document/'.$documents->getPublicKey()),
                'user'      => guard_url('document/documents/'.$documents->getRouteKey()),
            ], 
            'status'            => trans('app.'.$documents->status),
            'created_at'        => format_date($documents->created_at),
            'updated_at'        => format_date($documents->updated_at),
        ];
    }
}