<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'test',

    /*
     * Package.
     */
    'package'   => 'test',

    /*
     * Modules.
     */
    'modules'   => ['news', 'news-category'],


    'news'       => [
        'model'             => 'Test\Test\Models\News',
        'table'             => 'news',
        'presenter'         => \Test\Test\Repositories\Presenter\NewsItemPresenter::class,
        'hidden'            => [],
        'visible'           => [],
        'guarded'           => ['*'],
        'slugs'             => ['slug' => 'name'],
        'dates'             => ['deleted_at'],
        'appends'           => [],
        'fillable'          => ['user_id', 'news_title',  'cat_id'],
        'translate'         => ['news_title',  'cat_id'],

        'upload-folder'     => '/uploads/test/news',
        'uploads'           => [
                                    'single'    => [],
                                    'multiple'  => [],
                               ],
        'casts'             => [
                               ],
        'revision'          => [],
        'perPage'           => '20',
        'search'        => [
            'name'  => 'like',
            'status',
        ],
    ],    'news-category'       => [
        'model'             => 'Test\Test\Models\NewsCategory',
        'table'             => 'news-categories',
        'presenter'         => \Test\Test\Repositories\Presenter\NewsCategoryItemPresenter::class,
        'hidden'            => [],
        'visible'           => [],
        'guarded'           => ['*'],
        'slugs'             => ['slug' => 'name'],
        'dates'             => ['deleted_at'],
        'appends'           => [],
        'fillable'          => ['user_id', 'category_id'],
        'translate'         => ['category_id'],

        'upload-folder'     => '/uploads/test/news-category',
        'uploads'           => [
                                    'single'    => [],
                                    'multiple'  => [],
                               ],
        'casts'             => [
                               ],
        'revision'          => [],
        'perPage'           => '20',
        'search'        => [
            'name'  => 'like',
            'status',
        ],
    ],
];
