<?php

namespace Test\Test\Http\Controllers;

use App\Http\Controllers\PublicWebController as PublicController;
use Test\Test\Interfaces\NewsRepositoryInterface;

class NewsPublicWebController extends PublicController
{
    /**
     * Constructor.
     *
     * @param type \Test\News\Interfaces\NewsRepositoryInterface $news
     *
     * @return type
     */
    public function __construct(NewsRepositoryInterface $news)
    {
        $this->repository = $news;
        parent::__construct();
    }

    /**
     * Show news's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $news = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        return $this->theme->of('test::public.news.index', compact('news'))->render();
    }

    /**
     * Show news.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $news = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->theme->of('test::public.news.show', compact('news'))->render();
    }
}
