<?php

namespace Test\Test\Http\Controllers;

use App\Http\Controllers\UserWebController as UserController;
use Form;
use Test\Test\Http\Requests\NewsUserWebRequest;
use Test\Test\Interfaces\NewsRepositoryInterface;
use Test\Test\Models\News;

class NewsUserWebController extends UserController
{
    /**
     * Initialize news controller.
     *
     * @param type NewsRepositoryInterface $news
     *
     * @return type
     */
    public function __construct(NewsRepositoryInterface $news)
    {
        $this->repository = $news;
        parent::__construct();
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index(NewsUserWebRequest $request)
    {
        $this->repository->pushCriteria(new \Lavalite\Test\Repositories\Criteria\NewsUserCriteria());
        $news = $this->repository->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();

        $this->theme->prependTitle(trans('test::news.names').' :: ');

        return $this->theme->of('test::user.news.index', compact('news'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     * @param News $news
     *
     * @return Response
     */
    public function show(NewsUserWebRequest $request, News $news)
    {
        Form::populate($news);

        return $this->theme->of('test::user.news.show', compact('news'))->render();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(NewsUserWebRequest $request)
    {

        $news = $this->repository->newInstance([]);
        Form::populate($news);

        return $this->theme->of('test::user.news.create', compact('news'))->render();
    }

    /**
     * Display the specified resource.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(NewsUserWebRequest $request)
    {
        try {
            $attributes = $request->all();
            $attributes['user_id'] = user_id();
            $news = $this->repository->create($attributes);

            return redirect(trans_url('/user/test/news'))
                -> with('message', trans('messages.success.created', ['Module' => trans('test::news.name')]))
                -> with('code', 201);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Request $request
     * @param News $news
     *
     * @return Response
     */
    public function edit(NewsUserWebRequest $request, News $news)
    {

        Form::populate($news);

        return $this->theme->of('test::user.news.edit', compact('news'))->render();
    }

    /**
     * Update the specified resource.
     *
     * @param Request $request
     * @param News $news
     *
     * @return Response
     */
    public function update(NewsUserWebRequest $request, News $news)
    {
        try {
            $this->repository->update($request->all(), $news->getRouteKey());

            return redirect(trans_url('/user/test/news'))
                ->with('message', trans('messages.success.updated', ['Module' => trans('test::news.name')]))
                ->with('code', 204);

        } catch (Exception $e) {
            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);
        }
    }

    /**
     * Remove the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy(NewsUserWebRequest $request, News $news)
    {
        try {
            $this->repository->delete($news->getRouteKey());
            return redirect(trans_url('/user/test/news'))
                ->with('message', trans('messages.success.deleted', ['Module' => trans('test::news.name')]))
                ->with('code', 204);

        } catch (Exception $e) {

            redirect()->back()->withInput()->with('message', $e->getMessage())->with('code', 400);

        }
    }
}
