<?php

// Admin web routes  for news
Route::group(['prefix' => trans_setlocale().'/admin/test'], function () {
    Route::resource('news', 'Test\Test\Http\Controllers\NewsAdminWebController');
});

// Admin API routes  for news
Route::group(['prefix' => trans_setlocale().'api/v1/admin/test'], function () {
    Route::resource('news', 'Test\Test\Http\Controllers\NewsAdminApiController');
});

// User web routes for news
Route::group(['prefix' => trans_setlocale().'/user/test'], function () {
    Route::resource('news', 'Test\Test\Http\Controllers\NewsUserWebController');
});

// User API routes for news
Route::group(['prefix' => trans_setlocale().'api/v1/user/test'], function () {
    Route::resource('news', 'Test\Test\Http\Controllers\NewsUserApiController');
});

// Public web routes for news
Route::group(['prefix' => trans_setlocale().'/tests'], function () {
    Route::get('/', 'Test\Test\Http\Controllers\NewsPublicWebController@index');
    Route::get('/{slug?}', 'Test\Test\Http\Controllers\NewsPublicWebController@show');
});

// Public API routes for news
Route::group(['prefix' => trans_setlocale().'api/v1/tests'], function () {
    Route::get('/', 'Test\Test\Http\Controllers\NewsPublicApiController@index');
    Route::get('/{slug?}', 'Test\Test\Http\Controllers\NewsPublicApiController@show');
});

// Admin web routes  for news-category
Route::group(['prefix' => trans_setlocale().'/admin/test'], function () {
    Route::resource('news-category', 'Test\Test\Http\Controllers\NewsCategoryAdminWebController');
});

// Admin API routes  for news-category
Route::group(['prefix' => trans_setlocale().'api/v1/admin/test'], function () {
    Route::resource('news-category', 'Test\Test\Http\Controllers\NewsCategoryAdminApiController');
});

// User web routes for news-category
Route::group(['prefix' => trans_setlocale().'/user/test'], function () {
    Route::resource('news-category', 'Test\Test\Http\Controllers\NewsCategoryUserWebController');
});

// User API routes for news-category
Route::group(['prefix' => trans_setlocale().'api/v1/user/test'], function () {
    Route::resource('news-category', 'Test\Test\Http\Controllers\NewsCategoryUserApiController');
});

// Public web routes for news-category
Route::group(['prefix' => trans_setlocale().'/tests'], function () {
    Route::get('/', 'Test\Test\Http\Controllers\NewsCategoryPublicWebController@index');
    Route::get('/{slug?}', 'Test\Test\Http\Controllers\NewsCategoryPublicWebController@show');
});

// Public API routes for news-category
Route::group(['prefix' => trans_setlocale().'api/v1/tests'], function () {
    Route::get('/', 'Test\Test\Http\Controllers\NewsCategoryPublicApiController@index');
    Route::get('/{slug?}', 'Test\Test\Http\Controllers\NewsCategoryPublicApiController@show');
});

