<?php

namespace Test\Test\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Routing\Router;
use Test\Test\Models\Test;
use Request;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * This namespace is applied to the controller routes in your routes file.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'Test\Test\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param   \Illuminate\Routing\Router  $router
     * @return void
     */
    public function boot(Router $router)
    {
        parent::boot($router);

        if (Request::is('*/test/news/*')) {
            $router->bind('news', function ($id) {
                $news = $this->app->make('\Test\Test\Interfaces\NewsRepositoryInterface');
                return $news->findorNew($id);
            });
        }if (Request::is('*/test/news-category/*')) {
            $router->bind('news-category', function ($id) {
                $news-category = $this->app->make('\Test\Test\Interfaces\NewsCategoryRepositoryInterface');
                return $news-category->findorNew($id);
            });
        }

    }

    /**
     * Define the routes for the application.
     *
     * @param \Illuminate\Routing\Router $router
     *
     * @return void
     */
    public function map(Router $router)
    {
        $router->group(['namespace' => $this->namespace], function ($router) {
            require __DIR__ . '/../Http/routes.php';
        });
    }
}
