# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/example/example/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/example/example/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Example\\Example\\": "packages/example/example/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Example\Example\Providers\ExampleServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Example'  => Example\Example\Facades\Example::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Example\\ExampleTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/example/{modulename}

**User**

    http://path-to-route-folder/user/example/{modulename}

**Public**

    http://path-to-route-folder/examples


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/example/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/example/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/example/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/example/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/example/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/example/{modulename}/{slug}
    METHOD: GET