Lavalite package that provides example management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `example/example`.

    "example/example": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Example\Example\Providers\ExampleServiceProvider::class,

And also add it to alias

    'Example'  => Example\Example\Facades\Example::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Example\\ExampleTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Example\Example\Providers\ExampleServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/example/{modulename}

**User**

    http://path-to-route-folder/user/example/{modulename}

**Public**

    http://path-to-route-folder/examples


### API endpoints

**List**

    http://path-to-route-folder/api/user/example/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/example/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/example/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/example/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/example/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/example/{modulename}/{slug}
    METHOD: GET