<?php

// API routes  for example
Route::prefix('{guard}/example')->group(function () {
    Route::get('example/form/{element}', 'ExampleAPIController@form');
    Route::resource('example', 'ExampleAPIController');
});


if (Trans::isMultilingual()) {
    Route::group(
        [
            'prefix' => '{trans}',
            'where'  => ['trans' => Trans::keys('|')],
        ],
        function () {
            // Guard routes for examples
            Route::prefix('{guard}/example')->group(function () {
                Route::get('example/form/{element}', 'ExampleAPIController@form');
                Route::apiResource('example', 'ExampleAPIController');
            });
            // Public routes for examples
            Route::get('example/Example', 'ExamplePublicController@getExample');
        }
    );
}

