# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/firstdata/firstdatum/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {
         ...

        "classmap": [
            ...
            
            "packages/firstdata/firstdatum/database/seeds",
            
            ...
        ],
        "psr-4": {
            ...
            
            "Firstdata\\Firstdatum\\": "packages/firstdata/firstdatum/src",
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Firstdata\Firstdatum\Providers\FirstdatumServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Firstdatum'  => Firstdata\Firstdatum\Facades\Firstdatum::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Firstdata\\FirstdatumTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/firstdatum/{modulename}

**User**

    http://path-to-route-folder/user/firstdatum/{modulename}

**Public**

    http://path-to-route-folder/firstdatas


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/firstdatum/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/firstdatum/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/firstdatum/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/firstdatum/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/firstdatum/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/firstdatum/{modulename}/{slug}
    METHOD: GET