Lavalite package that provides firstdatum management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `firstdata/firstdatum`.

    "firstdata/firstdatum": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Firstdata\Firstdatum\Providers\FirstdatumServiceProvider::class,

And also add it to alias

    'Firstdatum'  => Firstdata\Firstdatum\Facades\Firstdatum::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Firstdata\\Firstdatum\\Seeds\\FirstdatumTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Firstdata\Firstdatum\Providers\FirstdatumServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/firstdatum/{modulename}

**User**

    http://path-to-route-folder/user/firstdatum/{modulename}

**Public**

    http://path-to-route-folder/firstdatas


### API endpoints

**List**

    http://path-to-route-folder/api/user/firstdatum/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/firstdatum/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/firstdatum/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/firstdatum/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/firstdatum/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/firstdatum/{modulename}/{slug}
    METHOD: GET