<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'ovr',

    /*
     * Package.
     */
    'package'   => 'form',

    /*
     * Modules.
     */
    'modules'   => ['sale', 'example'],

    'sale'       => [
        'model' => [
            'model'                 => \Ovr\Form\Models\Sale::class,
            'table'                 => 'sales',
            'presenter'             => \Ovr\Form\Repositories\Presenter\SalePresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'user_id',  'user_type',  'product_id',  'status',  'price',  'amount',  'quantity',  'date'],
            'translatables'         => [],
            'upload_folder'         => 'form/sale',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Ovr',
            'package'   => 'Form',
            'module'    => 'Sale',
        ],

    ],
    'example'       => [
        'model' => [
            'model'                 => \Ovr\Form\Models\Example::class,
            'table'                 => 'examples',
            'presenter'             => \Ovr\Form\Repositories\Presenter\ExamplePresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'name',  'email',  'color',  'date',  'datetime',  'file',  'files',  'image',  'images',  'month',  'password',  'range',  'search',  'tel',  'time',  'url',  'week',  'date_picker',  'time_picker',  'date_time_picker',  'radios',  'checkboxes',  'switch',  'select',  'model_select',  'tinyints',  'smallints',  'mediumints',  'ints',  'bigints',  'decimals',  'floats',  'doubles',  'reals',  'bits',  'booleans',  'dates',  'datetimes',  'timestamps',  'times',  'years',  'chars',  'varchars',  'tinytexts',  'texts',  'mediumtexts',  'longtexts',  'binarys',  'varbinarys',  'tinyblobs',  'mediumblobs',  'blobs',  'longblobs',  'enums',  'sets',  'slug',  'status',  'user_id',  'user_type',  'upload_folder',  'deleted_at',  'created_at',  'updated_at',  'PRIMARY'],
            'translatables'         => [],
            'upload_folder'         => 'form/example',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Ovr',
            'package'   => 'Form',
            'module'    => 'Example',
        ],

    ],
];
