<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: sales
         */
        Schema::create('sales', function ($table) {
            $table->increments('id');
            $table->integer('user_id')->nullable();
            $table->text('user_type')->nullable();
            $table->integer('product_id')->nullable();
            $table->enum('status', ['Sold','Pending'])->nullable();
            $table->double('price', 10,2)->nullable();
            $table->double('amount', 10,2)->nullable();
            $table->integer('quantity')->nullable();
            $table->date('date')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('sales');
    }
}
