<?php

namespace Ovr\Form;

use User;

class Form
{
    /**
     * $sale object.
     */
    protected $sale;    /**
     * $example object.
     */
    protected $example;

    /**
     * Constructor.
     */
    public function __construct(\Ovr\Form\Interfaces\SaleRepositoryInterface $sale,        \Ovr\Form\Interfaces\ExampleRepositoryInterface $example)
    {
        $this->sale = $sale;        $this->example = $example;
    }

    /**
     * Returns count of form.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.sale.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->sale->pushCriteria(new \Litepie\Ovr\Repositories\Criteria\SaleUserCriteria());
        }

        $sale = $this->sale->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('form::' . $view, compact('sale'))->render();
    }    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.example.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->example->pushCriteria(new \Litepie\Ovr\Repositories\Criteria\ExampleUserCriteria());
        }

        $example = $this->example->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('form::' . $view, compact('example'))->render();
    }
}
